import * as Results from '/res/gnr_express/WebResults/v02/LimResults.js';

const urlParams = new URLSearchParams(document.URL);
const docId = urlParams.get("doc_id");
const paneId = urlParams.get("pane_id");

window.limCurrentDocument = new LimNdDocument(docId);
window.limServerEventSource = new EventSource(`/api/v1/events?doc_id=${docId}&pane_id=${paneId}`);
limServerEventSource.onmessage = (event) => {
   try {
      const data = JSON.parse(event?.data);
      if (data?.object === "currentDocument" && typeof data?.signal === "string")
         limCurrentDocument?.[`on${data.signal[0].toUpperCase()}${data.signal.slice(1)}`]?.(data?.params);
   }
   catch (e) {
      console.log(e);
   }
}

(async function () {
   try {
      window.limResults = new Results.LimResults();
      limResults.docId = docId
      limResults.paneId = paneId
      document.body.appendChild(limResults);
      limResults?.onReady?.();
   }
   catch (e) {
      console.log(e);
   }
})();
