
const url = new URL(`/api/v1/image_info`, window.location.origin);
url.searchParams.append("doc_id", new URL(document.URL).searchParams.get("doc_id"));
const response = await fetch(url);
const imageInfo = await response.json();

const openTab = (ev, tabId) => {
    const tabcontent = document.getElementsByClassName("lim-tabcontent");
    for (let i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
    const tablinks = document.getElementsByClassName("lim-tablink");
    for (let i = 0; i < tablinks.length; i++) {
        tablinks[i].classList.remove("active");
    }
    document.getElementById(tabId).style.display = "block";
    ev.currentTarget.classList.add("active");
};

document.getElementById("lim-image-info-tablink-image-fields").onclick = (ev) => openTab(ev, "lim-image-info-tab-image-fields");
document.getElementById("lim-image-info-tablink-experiment-data").onclick = (ev) => openTab(ev, "lim-image-info-tab-experiment-data");
document.getElementById("lim-image-info-tablink-recorded-data").onclick = (ev) => openTab(ev, "lim-image-info-tab-recorded-data");
document.getElementById("lim-image-info-tablink-custom-metadata").onclick = (ev) => openTab(ev, "lim-image-info-tab-custom-metadata");
document.getElementById("lim-image-info-tablink-acquisition-details").onclick = (ev) => openTab(ev, "lim-image-info-tab-acquisition-details");

document.getElementById("lim-image-info-tablink-image-fields").click();
document.getElementById("lim-image-info-field-filename").innerText = imageInfo.filename;
document.getElementById("lim-image-info-field-path").innerText = imageInfo.path;
document.getElementById("lim-image-info-field-dimension").innerText = imageInfo.dimension;
document.getElementById("lim-image-info-field-sizes").innerText = imageInfo.sizes;
document.getElementById("lim-image-info-field-mtime").innerText = imageInfo.mtime;
document.getElementById("lim-image-info-field-appcreated").innerText = imageInfo.app_created;

document.getElementById("lim-text-info-calibration").innerText = imageInfo.calibration ?? "";
document.getElementById("lim-text-info-optics").innerText = imageInfo.imageTextInfo.optics ?? "";
document.getElementById("lim-text-info-type").innerText = imageInfo.imageTextInfo.type ?? "";
document.getElementById("lim-text-info-sample-id").innerText = imageInfo.imageTextInfo.sampleId ?? "";
document.getElementById("lim-text-info-author").innerText = imageInfo.imageTextInfo.author ?? "";
document.getElementById("lim-text-info-description").innerText = imageInfo.imageTextInfo.description ?? "";
document.getElementById("lim-text-info-image-id").innerText = imageInfo.imageTextInfo.imageId ?? "";
document.getElementById("lim-text-info-group").innerText = imageInfo.imageTextInfo.group ?? "";
document.getElementById("lim-text-info-capturing").innerText = imageInfo.imageTextInfo.capturing ?? "";
document.getElementById("lim-text-info-sampling").innerText = imageInfo.imageTextInfo.sampling ?? "";
document.getElementById("lim-text-info-location").innerText = imageInfo.imageTextInfo.location ?? "";
document.getElementById("lim-text-info-date").innerText = imageInfo.imageTextInfo.date ?? "";
document.getElementById("lim-text-info-conclusion").innerText = imageInfo.imageTextInfo.conclusion ?? "";
document.getElementById("lim-text-info-info-1").innerText = imageInfo.imageTextInfo.info1 ?? "";
document.getElementById("lim-text-info-info-2").innerText = imageInfo.imageTextInfo.info2 ?? "";

const experimentDataContainer = document.getElementById("lim-image-info-tab-experiment-data-container");
if (0 === (imageInfo?.experimentData?.length ?? 0)) {
    const name = document.createElement("div");
    name.style.margin = "20px";
    name.innerText = "No experiment data";
    experimentDataContainer.appendChild(name);    
}
else {
    for (let expLoop of imageInfo.experimentData) {
        const title = document.createElement("h3");
        title.textContent = expLoop.LoopName;
        experimentDataContainer.appendChild(title);
        const table = document.createElement("lim-virtual-treeview");
        table.classList.add(`${expLoop.ClassName}-loop`);    
        table.src = expLoop.InfoData;
        table.stickyCols = "1";
        experimentDataContainer.appendChild(table);
    }
}

const recordedDataTreeView = document.getElementById("lim-image-info-tab-recorded-data-treeview");
if (recordedDataTreeView) {
    const url = new URL(`/api/v1/image_recorded_data`, window.location.origin);
    url.searchParams.append("doc_id", new URL(document.URL).searchParams.get("doc_id"));
    recordedDataTreeView.src = url.toString();
}

const customMetadataContainer = document.getElementById("lim-image-info-tab-custom-metadata-container");
if (0 === (imageInfo?.customMetadata?.length ?? 0)) {
    const name = document.createElement("div");
    name.innerText = "No custom metadata";
    customMetadataContainer.appendChild(name);
}
else {
    for (let item of imageInfo.customMetadata) {
        const name = document.createElement("span");
        name.classList.add("lim-label");
        name.textContent = `${item.name}:`;
        customMetadataContainer.appendChild(name);
        const value = document.createElement("span");
        value.classList.add("lim-text");
        if (item.type==5)
            value.classList.add("lim-long-text");
        value.textContent = item.text;
        customMetadataContainer.appendChild(value);
    }
}

const acqDetailsTreeView = document.getElementById("lim-image-info-tab-acquisition-details-treeview");
acqDetailsTreeView.src = imageInfo.acquisitionDetails;